@extends('admin.layouts.app')

@section('content')
    <section class="section">
        <div class="section-header">
            <h1>{{ $pageTitle }}</h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="{{ getAdminPanelUrl() }}">{{trans('admin/main.dashboard')}}</a>
                </div>
                <div class="breadcrumb-item">{{ $pageTitle }}</div>
            </div>
        </div>

        <div class="section-body">
            <section class="card">

                <div class="card-header justify-content-between">
                            <div>
                                <h5 class="font-14 mb-0">{{ $pageTitle }}</h5>
                                <p class="font-12 mt-4 mb-0 text-gray-500">{{ trans('update.manage_all_courses_in_a_single_place') }}</p>
                            </div>

                            <div class="d-flex align-items-center gap-12">
                                    @can('admin_agora_history_export')
                                      <div class="text-right">
                                          <a href="{{ getAdminPanelUrl() }}/agora_history/excel" class="btn bg-white bg-hover-gray-100 border-gray-400 text-gray-500">
                                              <x-iconsax-lin-import-2 class="icons text-gray-500" width="18px" height="18px"/>
                                              <span class="ml-4 font-12">{{ trans('admin/main.export_xls') }}</span>
                                          </a>
                                      </div>
                                    @endcan

                            </div>
                        </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table custom-table text-center font-14">

                            <tr>
                                <th class="text-left">{{ trans('admin/main.course') }}</th>
                                <th class="text-left">{{ trans('admin/main.session') }}</th>
                                <th class="text-center">{{ trans('update.session_duration') }}</th>
                                <th class="text-center">{{ trans('admin/main.start_date') }}</th>
                                <th class="text-center">{{ trans('admin/main.end_date') }}</th>
                                <th class="text-center">{{ trans('update.meeting_duration') }}</th>
                            </tr>

                            @foreach($agoraHistories as $agoraHistory)
                                @php
                                    $meetingDuration = ($agoraHistory->end_at - $agoraHistory->start_at) / 60;
                                @endphp

                                <tr>
                                    <td class="text-left">{{ (!empty($agoraHistory->session) and !empty($agoraHistory->session->webinar)) ? $agoraHistory->session->webinar->title : trans('update.deleted_session') }}</td>
                                    <td class="text-left">{{ !empty($agoraHistory->session) ? $agoraHistory->session->title : trans('update.deleted_session') }}</td>
                                    <td>{{ !empty($agoraHistory->session) ? convertMinutesToHourAndMinute($agoraHistory->session->duration) : '-' }}</td>
                                    <td>{{ dateTimeFormat($agoraHistory->start_at, 'j M Y | H:i') }}</td>
                                    <td>{{ dateTimeFormat($agoraHistory->end_at, 'j M Y | H:i') }}</td>
                                    <td class="{{ !empty($agoraHistory->session) ? (($meetingDuration > $agoraHistory->session->duration) ? 'text-danger' : 'text-success') : '' }}">
                                        {{ convertMinutesToHourAndMinute($meetingDuration) }}
                                    </td>
                                </tr>
                            @endforeach
                        </table>
                    </div>
                </div>

                <div class="card-footer text-center">
                    {{ $agoraHistories->links() }}
                </div>
            </section>
        </div>
    </section>
@endsection
