/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!*********************************************************!*\
  !*** ./resources/js/admin/parts/settings/update_app.js ***!
  \*********************************************************/
(function ($) {
  "use strict";

  $('body').on('click', '.js-update-btn', function () {
    var $this = $(this);
    var $form = $this.closest('form');
    var path = $form.attr('action');
    $this.addClass('loadingbar primary').prop('disabled', true);
    $form.find('input').removeClass('is-invalid');
    var file = $form.find('input[type="file"]')[0].files[0];
    var formData = new FormData();
    formData.append("file", file);
    var items = $form.find('input, textarea, select').serializeArray();
    $.each(items, function () {
      formData.append(this.name, this.value);
    });
    $form.find('.progress').addClass('d-none');
    $.ajax({
      type: 'POST',
      url: path,
      data: formData,
      processData: false,
      contentType: false,
      cache: false,
      xhr: function xhr() {
        var xhr = new window.XMLHttpRequest();
        xhr.upload.addEventListener("progress", function (evt) {
          if (evt.lengthComputable) {
            var percentComplete = evt.loaded / evt.total * 100 - 1;
            $form.find('.progress').removeClass('d-none');
            var bar = $form.find('.progress .progress-bar');
            bar.css("width", percentComplete + '%');
            bar.text(percentComplete + '%');
          }
        }, false);
        return xhr;
      },
      success: function success(result) {
        if (result && result.code === 200) {
          //window.location.reload();
          Swal.fire({
            icon: 'success',
            html: '<p class="font-16 font-weight-500 text-center text-dark-blue py-25">' + result.msg + '</p>',
            showConfirmButton: false,
            width: '25rem'
          });
          setTimeout(function () {
            window.location.reload();
          }, 500);
        }
      },
      error: function error(err) {
        $form.find('.progress').addClass('d-none');
        $this.removeClass('loadingbar primary').prop('disabled', false);
        var errors = err.responseJSON;
        if (errors && errors.errors) {
          Object.keys(errors.errors).forEach(function (key) {
            var error = errors.errors[key];
            var element = $form.find('.js-ajax-' + key);
            element.addClass('is-invalid');
            element.parent().find('.invalid-feedback').text(error[0]);
          });
        }
      }
    });
  });
  $('body').on('click', '.js-database-update-btn', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $this.closest('form');
    var path = $form.attr('action');
    $this.addClass('loadingbar primary').prop('disabled', true);
    $form.find('input').removeClass('is-invalid');
    var data = $form.serializeObject();
    $.post(path, data, function (result) {
      if (result.code === 200) {
        $('.js-database-update-message').html(result.message);
      }
      $this.removeClass('loadingbar primary').prop('disabled', false);
    }).fail(function (err) {
      $form.find('.progress').addClass('d-none');
      $this.removeClass('loadingbar primary').prop('disabled', false);
      var errors = err.responseJSON;
      if (errors && errors.errors) {
        Object.keys(errors.errors).forEach(function (key) {
          var error = errors.errors[key];
          var element = $form.find('.js-ajax-' + key);
          element.addClass('is-invalid');
          element.parent().find('.invalid-feedback').text(error[0]);
        });
      }
    });
  });
})(jQuery);
/******/ })()
;