/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!*********************************************************!*\
  !*** ./resources/js/design_1/panel/meeting_settings.js ***!
  \*********************************************************/
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
(function ($) {
  "use strict";

  function handleTimePicker($timePicker) {
    $timePicker.persianDatepicker({
      format: 'H:m',
      calendarType: 'gregorian',
      calendar: {
        persian: {
          locale: 'en'
        }
      },
      onlyTimePicker: true,
      timePicker: {
        minute: {
          step: 5
        },
        second: {
          enabled: false
        }
      }
    });
  }
  $('body').on('click', '.js-add-time', function (e) {
    e.preventDefault();
    var day = $(this).closest('tr').attr('data-day');
    var modalTitle = $(this).attr('data-modalTitle');
    var path = "/panel/meetings/get-meeting-time-modal";
    handleBasicModal(path, modalTitle, function (result, $body, $footer) {
      var footerHtml = "<div class=\"w-100 text-right\">\n                <button type=\"button\" class=\"js-save-time btn btn-primary\" data-day=\"".concat(day, "\">").concat(saveLang, "</button>\n            </div>");
      $footer.html(footerHtml);
      var $timePicker = $body.find(".date-clock-picker");
      handleTimePicker($timePicker);
    }, '', '40rem');
  });
  $('body').on('click', '.js-save-time', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $('.js-meeting-time-form');
    var day = $this.attr('data-day');
    var data = $form.serializeObject();
    data['day'] = day;
    $this.addClass('loadingbar primary').prop('disabled', true);
    $.post('/panel/meetings/saveTime', data, function (result) {
      if (result && result.registration_package_limited) {
        handleLimitedAccountModal(result.registration_package_limited);
      } else if (result && result.code === 200) {
        Swal.fire({
          title: deleteAlertSuccess,
          html: "<div class=\"text-center pb-16\">".concat(successSavedTime, "</div>"),
          showConfirmButton: false,
          icon: 'success'
        });
        setTimeout(function () {
          window.location.reload();
        }, 1000);
      }
    }).fail(function (err) {
      $this.removeClass('loadingbar primary').prop('disabled', false);
      var errors = err.responseJSON;
      if (errors && errors.errors) {
        Object.keys(errors.errors).forEach(function (key) {
          var error = errors.errors[key];
          var element = $form.find('.js-ajax-' + key);
          element.addClass('is-invalid');
          element.parent().find('.invalid-feedback').text(error[0]);
        });
      }
    });
  });
  $('body').on('change', '#inPersonMeetingSwitch', function () {
    var inPersonMeetingAmount = $('#inPersonMeetingAmount');
    var inPersonGroupMeetingOptions = $('#inPersonGroupMeetingOptions');
    if (this.checked) {
      inPersonMeetingAmount.removeClass('d-none');
      if ($('#groupMeetingSwitch').is(':checked')) {
        inPersonGroupMeetingOptions.removeClass('d-none');
      }
    } else {
      inPersonMeetingAmount.addClass('d-none');
      inPersonGroupMeetingOptions.addClass('d-none');
    }
  });
  $('body').on('change', '#groupMeetingSwitch', function () {
    var onlineGroupMeetingOptions = $('#onlineGroupMeetingOptions');
    var inPersonGroupMeetingOptions = $('#inPersonGroupMeetingOptions');
    if (this.checked) {
      onlineGroupMeetingOptions.removeClass('d-none');
      if ($('#inPersonMeetingSwitch').is(':checked')) {
        inPersonGroupMeetingOptions.removeClass('d-none');
      }
    } else {
      onlineGroupMeetingOptions.addClass('d-none');
      inPersonGroupMeetingOptions.addClass('d-none');
    }
  });
  function deleteTimeModal(time_id) {
    var html = '<div class="px-16 pb-20">\n' + '    <p class="text-center">' + deleteAlertHint + '</p>\n' + '    <div class="mt-28 d-flex align-items-center justify-content-center">\n' + '        <button type="button" id="deleteTime" data-time-id="' + time_id + '" class="btn btn-sm btn-primary">' + deleteAlertConfirm + '</button>\n' + '        <button type="button" class="btn btn-sm btn-danger ml-12 close-swl">' + deleteAlertCancel + '</button>\n' + '    </div>\n' + '</div>';
    Swal.fire({
      title: deleteAlertTitle,
      html: html,
      icon: 'warning',
      showConfirmButton: false,
      showCancelButton: false,
      allowOutsideClick: function allowOutsideClick() {
        return !Swal.isLoading();
      }
    });
  }
  $('body').on('click', '.remove-time', function (e) {
    e.preventDefault();
    var $this = $(this);
    var time_id = $this.attr('data-time-id');
    deleteTimeModal(time_id);
  });
  $('body').on('click', '#deleteTime', function (e) {
    e.preventDefault();
    var $this = $(this);
    var time_id = $this.attr('data-time-id');
    time_id = time_id.split(',');
    handleRemoveTime(time_id);
    Swal.close();
    var _iterator = _createForOfIteratorHelper(time_id),
      _step;
    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var id = _step.value;
        $('.remove-time[data-time-id="' + id + '"]').parent().remove();
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }
  });
  function handleRemoveTime(time_id) {
    var data = {
      time_id: time_id
    };
    $.post('/panel/meetings/deleteTime', data, function (result) {
      showToast('success', deleteAlertSuccess, successDeleteTime);
    }).fail(function () {
      showToast('error', deleteAlertFail, errorDeleteTime);
    });
  }
  $('body').on('click', '.js-clear-all', function (e) {
    e.preventDefault();
    var parent = $(this).closest('tr');
    var timeIds = parent.find('.selected-time .remove-time').map(function () {
      return this.dataset.timeId;
    }).get();
    deleteTimeModal(timeIds.join(','));
  });
  $('body').on('click', '#meetingSettingFormSubmit', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $this.closest('form');
    var action = $form.attr('action');
    var data = serializeObjectByTag($form);
    $this.addClass('loadingbar primary').prop('disabled', true);
    $.post(action, data, function (result) {
      if (result && result.code === 200) {
        Swal.fire({
          icon: 'success',
          html: "<div class=\"p-16 text-center\"><p class=\"text-black\">".concat(saveMeetingSuccessLang, "</p></div>"),
          showConfirmButton: false,
          width: '25rem'
        });
        setTimeout(function () {
          window.location.reload();
        }, 500);
      }
    }).fail(function (err) {
      $this.removeClass('loadingbar primary').prop('disabled', false);
      var errors = err.responseJSON;
      if (errors && errors.errors) {
        Object.keys(errors.errors).forEach(function (key) {
          var error = errors.errors[key];
          var element = $form.find('[name="' + key + '"]');
          element.addClass('is-invalid');
          element.parent().find('.invalid-feedback').text(error[0]);
        });
      }
    });
  });
})(jQuery);
/******/ })()
;