/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!**************************************************!*\
  !*** ./resources/js/admin/parts/store/orders.js ***!
  \**************************************************/
(function ($) {
  "use strict";

  function makeEnterTrackingCodeModalHtml(order, saleId) {
    return "\n            <div>\n                <h3 class=\"section-title after-line font-20 text-dark-blue mb-25\">".concat(enterTrackingCodeModalTitleLang, "</h3>\n\n                <form action=\"").concat(adminPanelPrefix, "/store/orders/").concat(saleId, "/productOrder/").concat(order.id, "/setTrackingCode\" method=\"post\">\n\n                    <div class=\"mt-15 w-100\">\n                        <div class=\"\">\n                            <span class=\"font-weight-500 mr-5\">").concat(addressLang, " :</span>\n                            <span class=\"font-14 text-gray\">").concat(order.address, "</span>\n                        </div>\n                    </div>\n\n                    <div class=\"form-group mt-20\">\n                        <label class=\"input-label\">").concat(trackingCodeLang, "</label>\n                        <input type=\"text\" name=\"tracking_code\" class=\"form-control\" placeholder=\"\"/>\n                        <div class=\"invalid-feedback\"></div>\n                    </div>\n\n                    <div class=\"mt-30 d-flex align-items-center justify-content-end\">\n                        <button type=\"button\" id=\"saveTrackingCode\" class=\"btn btn-sm btn-primary\">").concat(saveLang, "</button>\n                        <button type=\"button\" class=\"btn btn-sm btn-danger ml-2 close-swl\">").concat(closeLang, "</button>\n                    </div>\n                </form>\n            </div>\n        ");
  }
  $('body').on('click', '.js-enter-tracking-code', function () {
    var $this = $(this);
    var saleId = $this.attr('data-sale-id');
    var orderId = $this.attr('data-product-order-id');
    var path = "".concat(adminPanelPrefix, "/store/orders/").concat(saleId, "/getProductOrder/").concat(orderId);
    $.get(path, function (result) {
      if (result && result.order) {
        Swal.fire({
          html: makeEnterTrackingCodeModalHtml(result.order, saleId),
          showCancelButton: false,
          showConfirmButton: false,
          customClass: {
            content: 'p-0 text-left'
          },
          width: '40rem'
        });
      }
    });
  });
  $('body').on('click', '#saveTrackingCode', function (e) {
    e.preventDefault();
    var $this = $(this);
    var form = $this.closest('form');
    var action = form.attr('action');
    $this.addClass('loadingbar primary').prop('disabled', true);
    form.find('input').removeClass('is-invalid');
    var data = form.serializeObject();
    $.post(action, data, function (result) {
      if (result && result.code === 200) {
        Swal.fire({
          icon: 'success',
          html: '<h3 class="font-20 text-center text-dark-blue py-25">' + trackingCodeSaveSuccessLang + '</h3>',
          showConfirmButton: false,
          width: '25rem'
        });
        setTimeout(function () {
          window.location.reload();
        }, 500);
      }
    }).fail(function (err) {
      $this.removeClass('loadingbar primary').prop('disabled', false);
      var errors = err.responseJSON;
      if (errors && errors.errors) {
        Object.keys(errors.errors).forEach(function (key) {
          var error = errors.errors[key];
          var element = form.find('[name="' + key + '"]');
          element.addClass('is-invalid');
          element.parent().find('.invalid-feedback').text(error[0]);
        });
      }
    });
  });
})(jQuery);
/******/ })()
;