/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!*************************************************************!*\
  !*** ./resources/js/design_1/panel/ai_content_generator.js ***!
  \*************************************************************/
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
(function ($) {
  "use strict";

  $('body').on('click', '.js-show-ai-content-drawer', function (e) {
    e.preventDefault();
    lockBodyScroll(true);
    $('.ai-content-generator-drawer').addClass('show');
  });
  $('body').on('click', '.js-right-drawer-close, .ai-content-generator-drawer-mask', function () {
    $('.ai-content-generator-drawer').removeClass('show');
    lockBodyScroll(false);
  });
  $('body').on('change', 'select[name="service_type"]', function () {
    var value = $(this).val();
    var $text = $('.js-text-templates-field');
    var $image = $('.js-image-templates-field');
    $text.addClass('d-none');
    $image.addClass('d-none');
    if (value === "text") {
      $text.removeClass('d-none');
    }
    if (value === "image") {
      $image.removeClass('d-none');
    }
  });
  $('body').on('change', '.js-text-service-templates', function () {
    var value = $(this).val();
    var $option = $(this).find('option:selected');
    var $lengthField = $('.js-service-length-field');
    var $forServiceField = $('.js-for-service-fields');
    var $questionField = $('.js-question-field');
    $questionField.addClass('d-none');
    $forServiceField.addClass('d-none');
    $lengthField.addClass('d-none');
    $lengthField.find('input').val('');
    if ($option.attr('data-enable-length') === "yes") {
      $lengthField.removeClass('d-none');
      var length = $option.attr('data-length');
      if (length && length > 0) {
        $lengthField.find('input').attr('max', length);
      }
    }
    if (value === "custom_text") {
      $questionField.removeClass('d-none');
    } else {
      $forServiceField.removeClass('d-none');
    }
  });
  $('body').on('change', '.js-image-service-templates', function () {
    var value = $(this).val();
    var $imageSizeField = $('.js-image-size-field');
    var $imageKeywordField = $('.js-image-keyword-field');
    var $imageQuestionField = $('.js-image-question-field');
    $imageSizeField.addClass('d-none');
    $imageSizeField.find('select').val('');
    $imageKeywordField.addClass('d-none');
    $imageKeywordField.find('input').val('');
    $imageQuestionField.addClass('d-none');
    $imageQuestionField.find('input').val('');
    if (value === "custom_image") {
      $imageSizeField.removeClass('d-none');
      $imageQuestionField.removeClass('d-none');
    } else {
      $imageKeywordField.removeClass('d-none');
    }
  });
  $('body').on('keyup', '.js-service-length-field input', function () {
    var $this = $(this);
    var value = $this.val();
    var max = $this.attr('max');
    var error = $this.attr('data-max-error');
    var $errorDiv = $this.closest('.form-group').find('.invalid-feedback');
    $this.removeClass('is-invalid');
    $errorDiv.text('');
    if (Number(value) > Number(max)) {
      $this.val(max);
      $this.addClass('is-invalid');
      $errorDiv.text("".concat(error, " ").concat(max));
    }
  });
  $('body').on('click', '.js-submit-ai-content-form', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $this.closest('form');
    var action = $form.attr('action');
    var data = $form.serializeObject();
    $this.addClass('loadingbar primary').prop('disabled', true);
    var $textCard = $('#generatedTextContents');
    var $imagesCard = $('.js-image-generated');
    $imagesCard.addClass('d-none');
    $textCard.addClass('d-none');
    $.post(action, data, function (result) {
      if (result.code === 200) {
        if (result.data) {
          if (result.data.contents && Object.keys(result.data.contents).length) {
            $textCard.removeClass('d-none');
            $textCard.html('');
            var _iterator = _createForOfIteratorHelper(result.data.contents),
              _step;
            try {
              for (_iterator.s(); !(_step = _iterator.n()).done;) {
                var content = _step.value;
                var html = makeTextContentHtml(content);
                $textCard.append(html);
              }
            } catch (err) {
              _iterator.e(err);
            } finally {
              _iterator.f();
            }
          }
          if (result.data.images && Object.keys(result.data.images).length) {
            $imagesCard.removeClass('d-none');
            $imagesCard.html('');
            var imageSize = "";
            if (typeof data.image_size !== "undefined") {
              imageSize = "".concat(data.image_size, "x").concat(data.image_size);
            }
            var _iterator2 = _createForOfIteratorHelper(result.data.images),
              _step2;
            try {
              for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                var image = _step2.value;
                var _html = makeImageContentHtml(image, imageSize);
                $imagesCard.append(_html);
              }
            } catch (err) {
              _iterator2.e(err);
            } finally {
              _iterator2.f();
            }
          }
        }
      }
      $this.removeClass('loadingbar primary').prop('disabled', false);
    }).fail(function (err) {
      $this.removeClass('loadingbar primary').prop('disabled', false);
      var errors = err.responseJSON;
      if (errors && errors.errors) {
        Object.keys(errors.errors).forEach(function (key) {
          var error = errors.errors[key];
          var element = $form.find('.js-ajax-' + key);
          element.addClass('is-invalid');
          element.parent().find('.invalid-feedback').text(error[0]);
        });
      }
    });
  });
  function makeImageContentHtml(imageLink) {
    var imageSize = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    return "<div class=\"d-flex align-items-center justify-content-between mt-16 rounded-16 p-12 border-gray-300 bg-white\">\n            <div class=\"d-flex align-items-center\">\n                <div class=\"size-80 rounded-8\">\n                    <img src=\"".concat(imageLink, "\" alt=\"image\" class=\"img-cover rounded-8\">\n                </div>\n\n                <div class=\"ml-8\">\n                    <h5 class=\"font-14 font-weight-bold text-gray-500\">").concat(generatedImageLang, "</h5>\n                    ").concat(imageSize ? "<p class=\"mt-8 font-12 text-gray-500\">".concat(imageSize, "</p>") : '', "\n                </div>\n            </div>\n\n            <a href=\"").concat(imageLink, "\" target=\"_blank\" class=\"d-flex-center size-40 rounded-circle bg-gray-100\">\n                ").concat(downloadIcon, "\n            </a>\n        </div>");
  }
  function makeTextContentHtml(text) {
    return "<div class=\"js-text-generated mt-16 p-16 rounded-16 bg-gray-100 border-gray-300\">\n            <div class=\"d-flex align-items-center justify-content-between\">\n                <h4 class=\"font-14 text-gray-500 font-weight-bold\">".concat(generatedContentLang, "</h4>\n\n                <div class=\"d-flex-center js-copy-content cursor-pointer\" data-toggle=\"tooltip\" data-placement=\"top\" title=\"").concat(copyLang, "\" data-copy-text=\"").concat(copyLang, "\" data-done-text=\"").concat(doneLang, "\">\n                    ").concat(copyIcon, "\n                </div>\n            </div>\n\n            <div class=\"mt-8 font-14 text-gray-500 js-content\">").concat(text, "</div>\n        </div>");
  }
  var copyTimeout;
  $('body').on('click', '.js-copy-content', function (e) {
    e.preventDefault();
    var $this = $(this);
    var copyText = $this.attr('data-copy-text');
    var doneText = $this.attr('data-done-text');
    var contentToCopy = $this.closest('.js-text-generated').find('.js-content').text();
    var tempTextarea = $('<textarea>').val(contentToCopy).appendTo('body').select();
    document.execCommand('copy');

    // Remove the temporary textarea
    tempTextarea.remove();
    $this.attr('data-original-title', doneText).tooltip('show');
    $this.attr('data-original-title', copyText);
  });
  $('body').on('click', '.js-view-content', function (e) {
    var _$parent$find$val;
    e.preventDefault();
    var $parent = $(this).parent();
    var prompt = (_$parent$find$val = $parent.find('.js-prompt').val()) !== null && _$parent$find$val !== void 0 ? _$parent$find$val : null;
    var result = $parent.find('.js-result').val();
    var html = '';
    if (prompt) {
      html += "<div class=\"js-prompt-card mb-16 pb-16 border-bottom-gray-200\">\n                        <h6 class=\"font-weight-bold font-14\">".concat(promptLang, "</h6>\n                        <p class=\"text-gray-500 font-12 mt-4\">").concat(prompt, "</p>\n                    </div>");
    }
    if (result) {
      result = JSON.parse(result);
      if (result.contents && Object.keys(result.contents).length) {
        var _iterator3 = _createForOfIteratorHelper(result.contents),
          _step3;
        try {
          for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
            var content = _step3.value;
            html += makeTextContentHtml(content);
          }
        } catch (err) {
          _iterator3.e(err);
        } finally {
          _iterator3.f();
        }
      }
      if (result.images && Object.keys(result.images).length) {
        var _iterator4 = _createForOfIteratorHelper(result.images),
          _step4;
        try {
          for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
            var image = _step4.value;
            html += makeImageContentHtml(image);
          }
        } catch (err) {
          _iterator4.e(err);
        } finally {
          _iterator4.f();
        }
      }
    }
    Swal.fire({
      html: makeModalHtml(generatedContentLang, closeIcon, html, '&nbsp;'),
      showCancelButton: false,
      showConfirmButton: false,
      customClass: {
        content: 'p-0 text-left'
      },
      width: '48rem',
      didOpen: function didOpen() {
        var $body = $('.js-custom-modal');
        var $footer = $('.custom-modal-footer');
      }
    });
  });
})(jQuery);
/******/ })()
;