/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!*****************************************************!*\
  !*** ./resources/js/design_1/panel/user_setting.js ***!
  \*****************************************************/
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i["return"] && (_r = _i["return"](), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
(function ($) {
  "use strict";

  $(document).ready(function () {
    var $countryCodeSelect2 = $('.country-code-select2');
    $countryCodeSelect2.select2({
      dropdownCssClass: "country-code-select2-dropdown",
      dropdownParent: 'body'
    });
    $countryCodeSelect2.on('select2:open', function (e) {
      var width = $('.register-mobile-form-group').width();
      $('.country-code-select2-dropdown').css('min-width', width - 6 + 'px');
    });
  });
  $('body').on('click', '#saveData', function (e) {
    e.preventDefault();
    $('#userSettingForm input[name="next_step"]').val(0);
    $(this).addClass('loadingbar primary').prop('disabled', true);
    $('#userSettingForm').trigger('submit');
  });
  function submitMetas($this, $input, name) {
    var user_id = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
    var metaId = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;
    var val = $input.val();
    $input.removeClass('is-invalid');
    if (val !== '' && val !== null) {
      var data = {
        name: name,
        value: val,
        user_id: user_id
      };
      var path = "/panel/setting/metas";
      if (metaId) {
        path = "/panel/setting/metas/".concat(metaId, "/update");
      }
      $.post(path, data, function (result) {
        if (result && result.code === 200) {
          Swal.fire({
            icon: 'success',
            html: '<h3 class="font-16 text-center py-20">' + saveSuccessLang + '</h3>',
            showConfirmButton: false,
            width: '25rem'
          });
          setTimeout(function () {
            window.location.reload();
          }, 500);
        }
      }).fail(function (err) {
        Swal.fire({
          icon: 'error',
          html: '<h3 class="font-16 text-center py-20">' + saveErrorLang + '</h3>',
          showConfirmButton: false,
          width: '25rem'
        });
        $this.removeClass('loadingbar primary').prop('disabled', false);
      });
    } else {
      $input.addClass('is-invalid');
      $this.removeClass('loadingbar primary').prop('disabled', false);
    }
  }
  $('body').on('change', '.js-user-bank-input', function (e) {
    e.preventDefault();
    var $optionSelected = $(this).find("option:selected");
    var specifications = $optionSelected.attr('data-specifications');
    var $card = $('.js-bank-specifications-card');
    var html = '';
    if (specifications) {
      Object.entries(JSON.parse(specifications)).forEach(function (_ref, key) {
        var _ref2 = _slicedToArray(_ref, 2),
          index = _ref2[0],
          item = _ref2[1];
        html += '<div class="form-group">\n' + '         <label class="form-group-label bg-white">' + item + '</label>\n' + '         <input type="text" name="bank_specifications[' + index + ']" value="" class="form-control bg-white"/>\n' + ' </div>';
      });
    }
    $card.html(html);
  });
  $('body').on('change', '#profileImage', function (event) {
    var $this = $(this);
    var _event$target$files = _slicedToArray(event.target.files, 1),
      file = _event$target$files[0];
    if (file) {
      $('#userProfileImage').attr('src', URL.createObjectURL(file));
    }
  });
  $('body').on('change', '#profileSecondaryImageInput', function (event) {
    var $this = $(this);
    var _event$target$files2 = _slicedToArray(event.target.files, 1),
      file = _event$target$files2[0];
    if (file) {
      var path = URL.createObjectURL(file);
      var img = "<img src=\"".concat(path, "\" alt=\"\" class=\"img-cover rounded-15\">");
      $('#profileSecondaryImageBox').html(img);
    }
  });
  $('body').on('change', '#signatureImageInput', function (event) {
    var $this = $(this);
    var _event$target$files3 = _slicedToArray(event.target.files, 1),
      file = _event$target$files3[0];
    if (file) {
      var path = URL.createObjectURL(file);
      var img = "<img src=\"".concat(path, "\" alt=\"\" class=\"img-cover rounded-15\">");
      $('#signatureImageBox').html(img);
    }
  });
  $('body').on('change', '#coverImageInput', function (event) {
    var $this = $(this);
    var _event$target$files4 = _slicedToArray(event.target.files, 1),
      file = _event$target$files4[0];
    if (file) {
      var path = URL.createObjectURL(file);
      var img = "<img src=\"".concat(path, "\" alt=\"\" class=\"img-cover rounded-15\">");
      $('#profileCoverBox').html(img);
    }
  });
  $('body').on('change', '#identity_scan, #certificate', function (event) {
    var $this = $(this);
    var _event$target$files5 = _slicedToArray(event.target.files, 1),
      file = _event$target$files5[0];
    if (file) {
      var value = this.value;
      var splited = value.split('\\');
      $this.closest('.custom-input-file').find('.js-file-name-span').text(splited[splited.length - 1]);
    }
  });

  /* Education */
  function handleEducationModal(title) {
    var userId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    var educationId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
    var educationValue = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
    var html = $('#newEducationModal').html();
    var footer = "<div class=\"d-flex align-items-center justify-content-end\">\n                <button type=\"button\" class=\"js-store-education btn btn-primary\" data-user-id=\"".concat(userId, "\" data-education-id=\"").concat(educationId, "\">").concat(submitRequestLang, "</button>\n        </div>");
    var body = makeModalHtml(title, closeIcon, html, footer);
    Swal.fire({
      html: body,
      showCancelButton: false,
      showConfirmButton: false,
      width: '36rem',
      didOpen: function didOpen() {
        $('.js-custom-modal #new_education_val').val(educationValue !== null && educationValue !== void 0 ? educationValue : '');
      }
    });
  }
  $('body').on('click', '.js-add-education', function (e) {
    e.preventDefault();
    var user_id = null;
    if ($('input#userId').length) {
      user_id = $('input#userId').val();
    }
    handleEducationModal(newEducationLang, user_id);
  });
  $('body').on('click', '.js-edit-education', function (e) {
    e.preventDefault();
    var $this = $(this);
    var userId = $this.attr('data-user-id');
    var educationId = $this.attr('data-education-id');
    var educationValue = $this.closest('.js-education-card').find('.js-education-value').text();
    handleEducationModal(editEducationLang, userId, educationId, educationValue);
  });
  $('body').on('click', '.js-store-education', function (e) {
    e.preventDefault();
    var $this = $(this);
    $this.addClass('loadingbar primary').prop('disabled', true);
    var $input = $('.js-custom-modal #new_education_val');
    var userId = $this.attr('data-user-id');
    var educationId = $this.attr('data-education-id');
    if (!userId || userId === "null") {
      userId = null;
    }
    if (!educationId || educationId === "null") {
      educationId = null;
    }
    submitMetas($this, $input, 'education', userId, educationId);
  });

  /* Experiences */
  function handleExperienceModal(title) {
    var userId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    var experienceId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
    var experienceValue = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
    var html = $('#newExperienceModal').html();
    var footer = "<div class=\"d-flex align-items-center justify-content-end\">\n                <button type=\"button\" class=\"js-store-experience btn btn-primary\" data-user-id=\"".concat(userId, "\" data-experience-id=\"").concat(experienceId, "\">").concat(submitRequestLang, "</button>\n        </div>");
    var body = makeModalHtml(title, closeIcon, html, footer);
    Swal.fire({
      html: body,
      showCancelButton: false,
      showConfirmButton: false,
      width: '36rem',
      didOpen: function didOpen() {
        $('.js-custom-modal #new_experience_val').val(experienceValue !== null && experienceValue !== void 0 ? experienceValue : '');
      }
    });
  }
  $('body').on('click', '.js-add-experience', function (e) {
    e.preventDefault();
    var user_id = null;
    if ($('input#userId').length) {
      user_id = $('input#userId').val();
    }
    handleExperienceModal(newExperienceLang, user_id);
  });
  $('body').on('click', '.js-edit-experience', function (e) {
    e.preventDefault();
    var $this = $(this);
    var userId = $this.attr('data-user-id');
    var experienceId = $this.attr('data-experience-id');
    var experienceValue = $this.closest('.js-experience-card').find('.js-experience-value').text();
    handleExperienceModal(editExperienceLang, userId, experienceId, experienceValue);
  });
  $('body').on('click', '.js-store-experience', function (e) {
    e.preventDefault();
    var $this = $(this);
    $this.addClass('loadingbar primary').prop('disabled', true);
    var $input = $('.js-custom-modal #new_experience_val');
    var userId = $this.attr('data-user-id');
    var experienceId = $this.attr('data-experience-id');
    if (!userId || userId === "null") {
      userId = null;
    }
    if (!experienceId || experienceId === "null") {
      experienceId = null;
    }
    submitMetas($this, $input, 'experience', userId, experienceId);
  });

  /* files & Attachments */
  function handleAttachmentModal(path, title) {
    handleBasicModal(path, title, function (result, $body, $footer) {
      var footerHtml = "<div class=\"d-flex align-items-center justify-content-end mt-25\">\n                <button type=\"button\" class=\"js-save-attachment btn btn-sm btn-primary\">".concat(saveLang, "</button>\n                <button type=\"button\" class=\"close-swl btn btn-sm btn-danger ml-8\">").concat(closeLang, "</button>\n            </div>");
      $footer.html(footerHtml);
    }, '', '40rem');
  }
  $('body').on('click', '.js-add-attachment', function (e) {
    var _$$attr;
    e.preventDefault();
    var userId = (_$$attr = $(this).attr("data-user")) !== null && _$$attr !== void 0 ? _$$attr : null;
    var path = "/panel/setting/attachments/get-form" + (userId ? "?user_id=".concat(userId) : '');
    handleAttachmentModal(path, newAttachmentLang);
  });
  $('body').on('click', '.js-edit-attachment', function (e) {
    e.preventDefault();
    var path = $(this).attr('data-path');
    handleAttachmentModal(path, editAttachmentLang);
  });
  $('body').on('click', '.js-save-attachment', function (e) {
    e.preventDefault();
    var $this = $(this);
    var form = $this.closest('.js-custom-modal').find('.js-attachment-form');
    handleSendRequestItemForm(form, $this);
  });
})(jQuery);
/******/ })()
;