/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!******************************************************!*\
  !*** ./resources/js/design_1/parts/get_view_data.js ***!
  \******************************************************/
(function ($) {
  "use strict";

  function handleTableIsLoading() {
    return "<div class=\"d-flex align-items-center js-view-data-loading\">\n                <img src=\"/assets/design_1/img/loading.svg\" alt=\"loading\" class=\"size-40\">\n                <span class=\"ml-4 text-gray-500\">".concat(loadingDataPleaseWaitLang, "</span>\n            </div>");
  }
  window.getViewData = function ($container, data) {
    var $btn = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
    var callback = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : undefined;
    var $tbody = $container.attr('data-body') ? $container.find($container.attr('data-body')) : $container.find('table tbody');
    var $pagination = $container.find('#pagination');
    var scrollTo = true;
    if ($btn && $btn.hasClass('view-data-without-scroll')) {
      scrollTo = false;
    }

    /* Scroll to top of container In Panel*/
    if (scrollTo) {
      var $panelScroller = $('#panelContentScrollable .simplebar-content-wrapper');
      if ($panelScroller.length) {
        $panelScroller.animate({
          scrollTop: $container.offset().top - 200
        }, 500);
      } else {
        $('html, body').animate({
          scrollTop: $container.offset().top - 200
        }, 500);
      }
    }

    /* Add Loading */
    $container.prepend(handleTableIsLoading());
    if ($btn) $btn.addClass('loadingbar primary').prop('disabled', true);
    var path = $container.attr('data-view-data-path');
    var noSearchResult = $container.find('.js-no-search-result');
    $.get(path, data, function (result) {
      if (result) {
        /* Remove Loading */
        $container.find('.js-view-data-loading').remove();
        if ($btn) $btn.removeClass('loadingbar primary').prop('disabled', false);
        $tbody.html(result.data);
        $pagination.html(result.pagination);
        if (noSearchResult.length) {
          noSearchResult.addClass('d-none');
          if (result.no_result) {
            noSearchResult.removeClass('d-none');
          }
        }
        if (result.specific_content && result.specific_content.el) {
          var $specificContentEl = $(result.specific_content.el);
          if ($specificContentEl.length) {
            var _result$specific_cont;
            $specificContentEl.removeClass('d-none');
            $specificContentEl.html((_result$specific_cont = result.specific_content.html) !== null && _result$specific_cont !== void 0 ? _result$specific_cont : '');
          }
        }
        if (typeof callback === "function") {
          callback();
        }
      }
    }).fail(function (err) {
      /* Remove Loading */
      $container.find('.js-view-data-loading').remove();
      if ($btn) $btn.removeClass('loadingbar primary').prop('disabled', false);
      showToast('error', oopsLang, somethingWentWrongLang);
    });
  };
  function handleSpecificThShow(value) {
    $('.js-specific-th').addClass('d-none');
    $(".js-".concat(value, "-th")).removeClass('d-none');

    //
    $('.js-not-specific-th').removeClass('d-none');
    $(".js-not-".concat(value, "-th")).addClass('d-none');
  }
  function handleRequestByFormInputOrBtn($this, $container) {
    var $form = $this.closest('form');
    var data = $form.serializeObject();
    var tabValue = null;
    var $tab = $('.js-get-view-data-by-tab.active');
    if ($tab.length) {
      var name = $tab.attr('data-filter-name');
      tabValue = $tab.attr('data-filter-value');
      data[name] = tabValue;
    }
    getViewData($container, data, $this, function () {
      if (tabValue) {
        handleSpecificThShow(tabValue);
      }
    });
  }
  $('body').on('click', '.js-get-view-data-by-form', function () {
    var $this = $(this);
    var $container = $('#' + $this.attr('data-container-id'));
    handleRequestByFormInputOrBtn($this, $container);
  });
  function changePanelTabActiveClass($tab) {
    var $parent = $tab.closest('.js-get-view-data-by-timeout-change');
    if (!$parent.length) {
      $parent = $tab.parent();
    }
    if ($tab.hasClass('navbar-item')) {
      $parent.find('.navbar-item').removeClass('active');
      $tab.addClass('active');
    } else {
      $parent.find('.js-get-view-data-by-tab').removeClass('text-primary');
      $tab.addClass('text-primary');
    }
  }
  var authChangeTimeout = undefined;
  var autoChangeEls = ".js-get-view-data-by-timeout-change input, .js-get-view-data-by-timeout-change textarea, .js-get-view-data-by-timeout-change select";
  $('body').on('change', autoChangeEls, function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $this.closest("form");
    var $container = $('#' + $form.attr('data-container-id'));
    if ($this.hasClass('js-just-reload-page')) {
      var name = $this.attr('name');
      var value = $this.val();
      var url = new URL(window.location.href);
      url.searchParams.set(name, value);
      window.location.href = url.href;
    } else {
      if (authChangeTimeout !== undefined) {
        clearTimeout(authChangeTimeout);
      }
      authChangeTimeout = setTimeout(function () {
        handleRequestByFormInputOrBtn($this, $container);
      }, 1500);
    }
  });
  $('body').on('click', '.js-get-view-data-by-tab', function (e) {
    e.preventDefault();
    var $this = $(this);
    var name = $this.attr('data-filter-name');
    var value = $this.attr('data-filter-value');
    var $container = $('#' + $this.attr('data-container-id'));
    var $form = $this.closest('form');
    var data = $form.serializeObject();
    data[name] = value;
    changePanelTabActiveClass($this);
    getViewData($container, data, null, function () {
      handleSpecificThShow(value);
    });
  });
  $(document).ready(function () {
    $('.js-get-view-data-default-init').each(function (i, item) {
      var $container = $(item);
      getViewData($container, {});
    });
  });
  $('body').on('click', '.js-ajax-pagination a.page-link', function (e) {
    e.preventDefault();
    var $this = $(this);
    var path = $this.attr('href');
    var $pagination = $this.closest('.js-ajax-pagination');
    var $container = $('#' + $pagination.attr('data-container-id'));
    var noscroll = $pagination.attr('data-noscroll');
    var $containerItems = $container;
    if ($pagination.attr('data-container-items')) {
      $containerItems = $($pagination.attr('data-container-items'));
    }

    /* Scroll to top of container In Panel*/
    if (!noscroll || noscroll !== "true") {
      var $panelScroller = $('#panelContentScrollable .simplebar-content-wrapper');
      if ($panelScroller.length) {
        $panelScroller.animate({
          scrollTop: $container.offset().top - 200
        }, 500);
      } else {
        $('html, body').animate({
          scrollTop: $container.offset().top - 200
        }, 500);
      }
    }

    /* Add Loading */
    $container.prepend(handleTableIsLoading());
    $.get(path, function (result) {
      if (result) {
        /* Remove Loading */
        $container.find('.js-view-data-loading').remove();
        $containerItems.html(result.data);
        if (result.pagination) {
          $pagination.html(result.pagination);
        }
      }
    });
  });
})(jQuery);
/******/ })()
;