/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!************************************************!*\
  !*** ./resources/js/design_1/parts/profile.js ***!
  \************************************************/
(function ($) {
  "use strict";

  $('body').on('click', '#followToggle', function (e) {
    e.preventDefault();
    var $this = $(this);
    $this.addClass('loadingbar').prop('disabled', true);
    var user_id = $this.attr('data-user-id');
    var path = '/users/' + user_id + '/follow';
    $.get(path, function (result) {
      $this.removeClass('loadingbar').prop('disabled', false);
      if (result && result.code === 200) {
        if (result.follow) {
          $this.removeClass('btn-primary').addClass('btn-danger');
          $this.text(unFollowLang);
        } else {
          $this.removeClass('btn-danger').addClass('btn-primary');
          $this.text(followLang);
        }
      }
    });
  });

  /**************
   * Send Message
   * **********/

  $('body').on('click', '.js-send-message', function (e) {
    e.preventDefault();
    var path = $(this).attr('data-path');
    handleBasicModal(path, sendMessageLang, function (result, $body, $footer) {
      var footerHtml = "<div class=\"d-flex align-items-center justify-content-end\">\n                    <button type=\"button\" class=\"js-send-message-submit btn btn-sm btn-primary\">".concat(sendMessageLang, "</button>\n                </div>");
      $footer.html(footerHtml);
      refreshCaptcha();
    }, '', '32rem');
  });
  $('body').on('click', '.js-send-message-submit', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $this.closest('.js-custom-modal').find('form');
    var path = $form.attr('action');
    handleSendRequestItemForm($form, $this, path);
  });

  // Courses
  var tabsLoadMore = {};
  $('body').on('click', '.js-profile-tab-load-more-btn', function (e) {
    e.preventDefault();
    var $this = $(this);
    var elId = $this.attr('data-el');
    var path = $this.attr('data-path');
    var $row = $("#".concat(elId));
    if (typeof tabsLoadMore[elId] === "undefined") {
      tabsLoadMore[elId] = {
        page: 1
      };
    }
    var page = tabsLoadMore[elId].page + 1;
    var data = {
      page: page
    };
    $this.addClass('loadingbar').prop('disabled', true);
    $.post(path, data, function (result) {
      if (result) {
        tabsLoadMore[elId].page = page;
        if (result.data) {
          $row.append(result.data);
        }
        if (!result.has_more_item) {
          $this.parent().remove();
        }
      }
    }).always(function () {
      $this.removeClass('loadingbar').prop('disabled', false);
    });
  });

  /*******
  * Calendar
  *  */
})(jQuery);
/******/ })()
;