/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!****************************************************!*\
  !*** ./resources/js/design_1/parts/topic_posts.js ***!
  \****************************************************/
(function ($) {
  "use strict";

  $('body').on('click', '.login-to-access', function (e) {
    e.preventDefault();
    if (notLoginToastTitleLang && notLoginToastMsgLang) {
      showToast('error', notLoginToastTitleLang, notLoginToastMsgLang);
    }
  });
  $('body').on('click', '.js-topic-bookmark', function (e) {
    e.preventDefault();
    var $this = $(this);
    var action = $this.attr('data-action');
    if ($this.hasClass('text-primary')) {
      $this.removeClass('text-primary').addClass('text-gray-500');
    } else {
      $this.removeClass('text-gray-500').addClass('text-primary');
    }
    $.post(action, {}, function (result) {
      if (result && result.code === 200) {
        showToast('success', result.title, result.msg);
      }
    }).fail(function (err) {
      showToast('error', oopsLang, somethingWentWrongLang);
    });
  });

  /* Like */
  $('body').on('click', '.js-topic-post-like', function (e) {
    e.preventDefault();
    var $this = $(this);
    var parent = $this.closest('.js-topic-post-like-btn-parent');
    var likeCount = parent.find('.js-like-count').text();
    var action = $this.attr('data-action');
    var isLiked = $this.hasClass('liked');
    var $emptyIcon = $this.find('.js-empty-like-icon');
    var $fullIcon = $this.find('.js-full-like-icon');
    if (isLiked) {
      $emptyIcon.removeClass('d-none');
      $fullIcon.addClass('d-none');
    } else {
      $emptyIcon.addClass('d-none');
      $fullIcon.removeClass('d-none');
    }
    var newLikeCount = isLiked ? likeCount - 1 : Number(likeCount) + 1;
    parent.find('.js-like-count').text(newLikeCount);
    $.post(action, {}, function (result) {
      if (result && result.code === 200) {
        parent.find('.js-like-count').text(result.likes);
        if (result.status) {
          $this.addClass('liked');
        } else {
          $this.removeClass('liked');
        }
      }
    }).fail(function (err) {
      parent.find('.js-like-count').text(likeCount);
    });
  });

  /**
   * report modal
   * */
  $('body').on('click', '.js-topic-post-report', function (e) {
    e.preventDefault();
    var $this = $(this);
    var itemId = $this.attr('data-id');
    var type = $this.attr('data-type');
    var path = $this.attr("data-path") + "?type=".concat(type, "&item=").concat(itemId);
    handleBasicModal(path, reportLang, function (result, $body, $footer) {
      var footerHtml = "<div class=\"d-flex align-items-center justify-content-end\">\n                <button type=\"button\" class=\"js-submit-report-btn btn btn-primary\">".concat(reportLang, "</button>\n            </div>");
      $footer.html(footerHtml);
    }, '', '40rem');
  });
  $('body').on('click', '.js-submit-report-btn', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $this.closest('.js-custom-modal').find('.js-topic-report-form');
    var path = $form.attr("data-action");
    handleSendRequestItemForm($form, $this, path);
  });

  /**
   * Pin & Unpin
   * */
  $('body').on('click', '.js-btn-post-un-pin, .js-btn-post-pin', function (e) {
    e.preventDefault();
    var $this = $(this);
    var action = $this.attr('data-action');
    if ($this.hasClass('text-warning')) {
      $this.removeClass('text-warning').addClass('text-gray-500');
    } else {
      $this.removeClass('text-gray-500').addClass('text-warning');
    }
    $.post(action, {}, function (result) {
      if (result.code === 200) {
        showToast('success', result.title, result.msg);
      }
    }).fail(function (err) {
      showToast('error', oopsLang, somethingWentWrongLang);
    });
  });

  /**
   * Save & Edit Post
   * */
  $('body').on('click', '.js-save-post-btn', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $this.closest('form');
    var path = $form.attr("action");
    handleSendRequestItemForm($form, $this, path, null, false);
  });
  $('body').on('click', '.js-post-edit', function (e) {
    e.preventDefault();
    var $this = $(this);
    var path = $this.attr("data-action");
    handleBasicModal(path, editPostLang, function (result, $body, $footer) {
      // Make Editor
      makeSummernote($body.find('.js-edit-post-summernote'), 350);
      var footerHtml = "<div class=\"d-flex align-items-center justify-content-end\">\n                <button type=\"button\" class=\"js-submit-edit-post-btn btn btn-primary\">".concat(saveLang, "</button>\n            </div>");
      $footer.html(footerHtml);
    }, '', '50rem');
  });
  $('body').on('click', '.js-submit-edit-post-btn', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $modal = $this.closest('.js-custom-modal');
    var $form = $modal.find('form');
    var path = $form.attr("action");
    handleSendRequestItemForm($form, $this, path, null, false);
  });

  /**
   * Replay Post
   * */
  $('body').on('click', '.js-reply-post-btn', function (e) {
    e.preventDefault();
    var $this = $(this);
    var postId = $this.attr('data-id');
    var $card = $this.closest('.topic-post-card');
    var userAvatarPath = $card.find('.js-user-avatar').attr('src');
    var userFullName = $card.find('.js-user-name').text();
    var description = '';
    $card.find('.js-topic-post-description').contents().filter(function () {
      description += this.innerText;
    });
    var shortText = jQuery.trim(description).substring(0, 125).split(" ").slice(0, -1).join(" ") + "...";
    var $replyCard = $('.js-topic-post-reply-card');
    $replyCard.removeClass('d-none');
    $replyCard.find('.js-reply-post-id').val(postId);
    $replyCard.find('.js-reply-post-user-avatar').attr('src', userAvatarPath);
    $replyCard.find('.js-reply-post-user-name b').text(userFullName);
    $replyCard.find('.js-reply-post-description').text(shortText);
    $('html, body').animate({
      scrollTop: $replyCard.offset().top - 100
    }, 500);
  });
  $('body').on('click', '.js-close-reply-post', function (e) {
    e.preventDefault();
    var $replyCard = $(this).closest('.js-topic-post-reply-card');
    $replyCard.addClass('d-none');
    $replyCard.find('.js-reply-post-id').val('');
  });
})(jQuery);
/******/ })()
;